/* 
 *  GetUserDataRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import java.util.ArrayList;
import java.util.List;

import com.avaya.ccs.api.UserI;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.SupervisorDataGUI;
import com.avaya.ccs.javafxrefclient.UserData;
import com.avaya.ccs.javafxrefclient.UserDataGUI;

import javafx.concurrent.WorkerStateEvent;

public class GetUserDataRequest extends SessionRequest {

    private static final Logger LOG = Logger.getLogger(GetUserDataRequest.class);
    private final UserDataGUI gui;
    private final SupervisorDataGUI superGui;

    public GetUserDataRequest(UserDataGUI gui, SupervisorDataGUI gui2) {
        super(LOG);
        this.gui = gui;
        this.superGui = gui2;
    }

    /**
     * The call method executes on the outgoingRequest thread
     * 
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        List<UserData> data = new ArrayList<>();
        List<UserI> users = new ArrayList<>();
        users.addAll(getSession().getUsers());
        for (UserI i : users) {
            data.add(new UserData(i));
        }
        LOG.trace(methodName + "+");
        return data;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            @SuppressWarnings("unchecked")
            List<UserData> value = (List<UserData>) t.getSource().valueProperty().getValue();
            if (value != null) {
                // The value is returned from the call() method above so
                // will always be the correct type
                // The only way to check the type to avoid a warning is to
                // iterate over the list, instead suppress the warning
                LOG.debug(methodName + "List<UserData>:" + value);
                gui.UpdateUserData(value);
                superGui.UpdateUserData(value);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }
}
